#!/usr/bin/env python3
import csv, sys

rows = {r["comm"]: float(r["norm"]) for r in csv.DictReader(open("results/commutator_norms.csv", newline=""))}

assert rows["[R,S]"] >= 1e-3,  f"Arrow too small: [R,S]={rows['[R,S]']}"
assert rows["[C,R]"] <= 5e-4,  f"Lock fail: [C,R]={rows['[C,R]']}"
assert rows["[C,S]"] <= 5e-4,  f"Lock fail: [C,S]={rows['[C,S]']}"

print("ACCEPTANCE PASS:", rows)
